# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Test decorated ``check`` command."""

from unittest import mock

from django.core.management import CommandError
from django.db.utils import DatabaseError

from debusine.django.management.tests import call_command
from debusine.test.django import TestCase


class CheckCommandTests(TestCase):
    """Tests for the ``check`` command."""

    def test_operational_error_is_caught(self) -> None:
        """Test that OperationalError raised in execute is dealt with."""
        with (
            mock.patch(
                "django.core.management.BaseCommand.execute",
                side_effect=DatabaseError("Boom"),
            ),
            self.assertRaisesRegex(
                CommandError, r"^Database error: Boom$"
            ) as raised,
        ):
            call_command("check")

        self.assertEqual(raised.exception.returncode, 3)
