//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DatabaseSQLVulnerabilityAssessmentScanResultClient contains the methods for the DatabaseSQLVulnerabilityAssessmentScanResult group.
// Don't use this type directly, use NewDatabaseSQLVulnerabilityAssessmentScanResultClient() instead.
type DatabaseSQLVulnerabilityAssessmentScanResultClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDatabaseSQLVulnerabilityAssessmentScanResultClient creates a new instance of DatabaseSQLVulnerabilityAssessmentScanResultClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDatabaseSQLVulnerabilityAssessmentScanResultClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DatabaseSQLVulnerabilityAssessmentScanResultClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DatabaseSQLVulnerabilityAssessmentScanResultClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets a vulnerability assessment scan record of a database.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the SQL Vulnerability Assessment.
//   - scanID - The scan id of the SQL Vulnerability Assessment scan to retrieve result from.
//   - scanResultID - The scan result id of the specific result to retrieve.
//   - options - DatabaseSQLVulnerabilityAssessmentScanResultClientGetOptions contains the optional parameters for the DatabaseSQLVulnerabilityAssessmentScanResultClient.Get
//     method.
func (client *DatabaseSQLVulnerabilityAssessmentScanResultClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, scanID string, scanResultID string, options *DatabaseSQLVulnerabilityAssessmentScanResultClientGetOptions) (DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse, error) {
	var err error
	const operationName = "DatabaseSQLVulnerabilityAssessmentScanResultClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanID, scanResultID, options)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DatabaseSQLVulnerabilityAssessmentScanResultClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, scanID string, scanResultID string, options *DatabaseSQLVulnerabilityAssessmentScanResultClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if scanResultID == "" {
		return nil, errors.New("parameter scanResultID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanResultId}", url.PathEscape(scanResultID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DatabaseSQLVulnerabilityAssessmentScanResultClient) getHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanResults); err != nil {
		return DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse{}, err
	}
	return result, nil
}

// NewListByScanPager - Gets a vulnerability assessment scan record of a database.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the SQL Vulnerability Assessment.
//   - scanID - The scan id of the SQL Vulnerability Assessment scan to retrieve result from.
//   - options - DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanOptions contains the optional parameters for the
//     DatabaseSQLVulnerabilityAssessmentScanResultClient.NewListByScanPager method.
func (client *DatabaseSQLVulnerabilityAssessmentScanResultClient) NewListByScanPager(resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, scanID string, options *DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanOptions) *runtime.Pager[DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse] {
	return runtime.NewPager(runtime.PagingHandler[DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse]{
		More: func(page DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse) (DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DatabaseSQLVulnerabilityAssessmentScanResultClient.NewListByScanPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByScanCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanID, options)
			}, nil)
			if err != nil {
				return DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse{}, err
			}
			return client.listByScanHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByScanCreateRequest creates the ListByScan request.
func (client *DatabaseSQLVulnerabilityAssessmentScanResultClient) listByScanCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, scanID string, options *DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByScanHandleResponse handles the ListByScan response.
func (client *DatabaseSQLVulnerabilityAssessmentScanResultClient) listByScanHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanListResult); err != nil {
		return DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse{}, err
	}
	return result, nil
}
