// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/safe_browsing/core/db/prefix_iterator.h"

namespace safe_browsing {

PrefixIterator::PrefixIterator(base::StringPiece prefixes,
                               size_t index,
                               size_t size)
    : prefixes_(prefixes), index_(index), size_(size) {}

PrefixIterator::PrefixIterator(const PrefixIterator& rhs)
    : prefixes_(rhs.prefixes_), index_(rhs.index_), size_(rhs.size_) {}

}  // namespace safe_browsing
